% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residualPlot.R
\name{residualPlot}
\alias{residualPlot}
\title{Draw a martingale residual plot with an object of class coxph}
\usage{
residualPlot(fit, mode = 1)
}
\arguments{
\item{fit}{An object of class coxph}

\item{mode}{Integer If mode is 1, draw martingale residual plot.
If mode is 2, draw dfbeta plot. if mode is 3, draw risk score plot}
}
\value{
A ggplot
}
\description{
Draw a martingale residual plot with an object of class coxph
}
\examples{
require(survival)
fit=coxph(Surv(time,status==2)~log(bili)+age+cluster(edema),data=pbc)
residualPlot(fit)
}
