% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_stratification.R
\name{post_stratification}
\alias{post_stratification}
\title{Apply post-stratification to classifiers.}
\usage{
post_stratification(
  y,
  L1.x,
  L2.x,
  L2.unit,
  L2.reg,
  best.subset.opt,
  lasso.opt,
  lasso.L2.x,
  pca.opt,
  gb.opt,
  svm.opt,
  svm.L2.reg,
  svm.L2.unit,
  svm.L2.x,
  mrp.include,
  n.minobsinnode,
  L2.unit.include,
  L2.reg.include,
  kernel,
  mrp.L2.x,
  data,
  ebma.fold,
  census,
  verbose
)
}
\arguments{
\item{y}{Outcome variable. A character vector containing the column names of
the outcome variable. A character scalar containing the column name of
the outcome variable in \code{survey}.}

\item{L1.x}{Individual-level covariates. A character vector containing the
column names of the individual-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}. Note that geographic unit
is specified in argument \code{L2.unit}.}

\item{L2.x}{Context-level covariates. A character vector containing the
column names of the context-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}.}

\item{L2.unit}{Geographic unit. A character scalar containing the column
name of the geographic unit in \code{survey} and \code{census} at which
outcomes should be aggregated.}

\item{L2.reg}{Geographic region. A character scalar containing the column
name of the geographic region in \code{survey} and \code{census} by which
geographic units are grouped (\code{L2.unit} must be nested within
\code{L2.reg}). Default is \code{NULL}.}

\item{best.subset.opt}{Optimal tuning parameters from best subset selection
classifier. A list returned by \code{run_best_subset()}.}

\item{lasso.opt}{Optimal tuning parameters from lasso classifier A list
returned by \code{run_lasso()}.}

\item{lasso.L2.x}{Lasso context-level covariates. A character vector
containing the column names of the context-level variables in
\code{survey} and \code{census} to be used by the lasso classifier. If
\code{NULL} and \code{lasso} is set to \code{TRUE}, then lasso uses the
variables specified in \code{L2.x}. Default is \code{NULL}.}

\item{pca.opt}{Optimal tuning parameters from best subset selection with
principal components classifier A list returned by \code{run_pca()}.}

\item{gb.opt}{Optimal tuning parameters from gradient tree boosting
classifier A list returned by \code{run_gb()}.}

\item{svm.opt}{Optimal tuning parameters from support vector machine
classifier A list returned by \code{run_svm()}.}

\item{svm.L2.reg}{SVM L2.reg. A logical argument indicating whether
\code{L2.reg} should be included in the SVM classifier. Default is
\code{FALSE}.}

\item{svm.L2.unit}{SVM L2.unit. A logical argument indicating whether
\code{L2.unit} should be included in the SVM classifier. Default is
\code{FALSE}.}

\item{svm.L2.x}{SVM context-level covariates. A character vector containing
the column names of the context-level variables in \code{survey} and
\code{census} to be used by the SVM classifier. If \code{NULL} and
\code{svm} is set to \code{TRUE}, then SVM uses the variables specified in
\code{L2.x}. Default is \code{NULL}.}

\item{mrp.include}{Whether to run MRP classifier. A logical argument
indicating whether the standard MRP classifier should be used for
predicting outcome \code{y}. Passed from \code{autoMrP()} argument
\code{mrp}.}

\item{n.minobsinnode}{GB minimum number of observations in the terminal
nodes. An integer-valued scalar specifying the minimum number of
observations that each terminal node of the trees must contain. Passed from
\code{autoMrP()} argument \code{gb.n.minobsinnode}.}

\item{L2.unit.include}{GB L2.unit. A logical argument indicating whether
\code{L2.unit} should be included in the GB classifier. Passed from
\code{autoMrP()} argument \code{gb.L2.unit}.}

\item{L2.reg.include}{A logical argument indicating whether \code{L2.reg}
should be included in the GB classifier. Passed from \code{autoMrP()}
argument \code{GB L2.reg}.}

\item{kernel}{SVM kernel. A character-valued scalar specifying the kernel to
be used by SVM. The possible values are \code{linear}, \code{polynomial},
\code{radial}, and \code{sigmoid}. Passed from \code{autoMrP()} argument
\code{svm.kernel}.}

\item{mrp.L2.x}{MRP context-level covariates. A character vector containing
the column names of the context-level variables in \code{survey} and
\code{census} to be used by the MRP classifier. The character vector
\emph{empty} if no context-level variables should be used by the MRP
classifier. If \code{NULL} and \code{mrp} is set to \code{TRUE}, then MRP
uses the variables specified in \code{L2.x}. Default is \code{NULL}.}

\item{data}{A data.frame containing the survey data used in classifier
training.}

\item{ebma.fold}{A data.frame containing the data not used in classifier
training.}

\item{census}{Census data. A \code{data.frame} whose column names include
\code{L1.x}, \code{L2.x}, \code{L2.unit}, if specified, \code{L2.reg} and
\code{pcs}, and either \code{bin.proportion} or \code{bin.size}.}

\item{verbose}{Verbose output. A logical argument indicating whether or not
verbose output should be printed. Default is \code{FALSE}.}
}
\description{
Apply post-stratification to classifiers.
}
