% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{ui-server}
\alias{ui-server}
\alias{auth0_ui}
\alias{auth0_server}
\title{Modifies ui/server objects to authenticate using Auth0.}
\usage{
auth0_ui(ui, info)

auth0_server(server, info)
}
\arguments{
\item{ui}{\code{shiny.tag.list} object to generate the user interface.}

\item{info}{object returned from \link{auth0_info}. If not informed,
will try to find the \code{_auth0.yml} and create it automatically.}

\item{server}{the shiny server function.}
}
\description{
These functions can be used in a ui.R/server.R framework, modifying the
shiny objects to authenticate using Auth0 service with no pain.
}
\examples{
\donttest{
# first, create the yml file using use_auth0() function

# ui.R file
library(shiny)
library(auth0)
auth0_ui(fluidPage(logoutButton()))

# server.R file
library(auth0)
auth0_server(function(input, output, session) {})

# console
options(shiny.port = 8080)
shiny::runApp()

}
}
\seealso{
\link{auth0_info}.
}
