% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{auth0_logout_url}
\alias{auth0_logout_url}
\title{Generate logout URL}
\usage{
auth0_logout_url(config_file = NULL, redirect_js = TRUE)
}
\arguments{
\item{config_file}{Path to YAML configuration file.}

\item{redirect_js}{include javascript code to redirect page? Defaults to \code{TRUE}.}
}
\description{
\code{auth0_logout_url()} is defunct as of auth0 0.1.2 in order to simplifly the
user experience with the \code{\link[=logoutButton]{logoutButton()}} function.
}
\examples{
\donttest{

# simple UI with action button
# AFTER auth0 0.1.2

library(shiny)
library(auth0)

ui <- fluidPage(logoutButton())
server <- function(input, output, session) {}
shinyAppAuth0(ui, server, config_file)

# simple UI with action button
# BEFORE auth0 0.1.2

library(shiny)
library(auth0)
library(shinyjs)

# note that you must include shinyjs::useShinyjs() for this to work
ui <- fluidPage(shinyjs::useShinyjs(), actionButton("logout_auth0", "Logout"))

# server with one observer that logouts
server <- function(input, output, session) {
  observeEvent(input$logout_auth0, {
    # javascript code redirecting to correct url
    js <- auth0_logout_url()
    shinyjs::runjs(js)
  })
}

shinyAuth0App(ui, server, config_file = config_file)
}


}
