% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet.R
\name{extract_params.cv.glmnet}
\alias{extract_params.cv.glmnet}
\title{extract_params.cv.glmnet}
\usage{
\method{extract_params}{cv.glmnet}(object, lambda = object[["lambda.1se"]],
  ...)
}
\arguments{
\item{object}{an object of class "cv.glmnet"}

\item{lambda}{a numeric value of the penalty parameter lambda at which 
coefficients are required}

\item{...}{further arguments passed to or from other methods}
}
\value{
PFA as a \code{list} of lists that can be inserted into a cell or pool
}
\description{
Extract generalized linear model net parameters from a cv.glmnet object
}
\examples{
X <- matrix(c(rnorm(100), runif(100)), nrow=100, ncol=2)
Y <- factor(3 - 5 * X[,1] + 3 * X[,2] + rnorm(100, 0, 3) > 0)

model <- glmnet::cv.glmnet(X, Y, family = 'binomial')
my_model_params <- extract_params(model)
}
