% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomForest.R
\name{build_model.randomForest}
\alias{build_model.randomForest}
\title{build_model.randomForest}
\usage{
\method{build_model}{randomForest}(object, which_tree = 1, ...)
}
\arguments{
\item{object}{a object of class randomForest}

\item{which_tree}{an integer indicating which single tree to build}

\item{...}{further arguments passed to or from other methods}
}
\value{
a \code{list} of lists representation of the tree that can be 
inserted into a cell or pool
}
\description{
Builds an entire PFA list of lists based on a single randomForest model tree
}
\examples{
dat <- data.frame(X1 = runif(100), 
                  X2 = rnorm(100))
dat$Y <- factor((rexp(100,5) + 5 * dat$X1 - 4 * dat$X2) > 0)

model <- randomForest::randomForest(Y ~ X1 + X2, data=dat, ntree=10)
my_tree <- build_model(model, 1)
}
