% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm.R
\name{build_model.gbm}
\alias{build_model.gbm}
\title{build_model.gbm}
\usage{
\method{build_model}{gbm}(object, which_tree = 1, ...)
}
\arguments{
\item{object}{a object of class gbm}

\item{which_tree}{an integer indicating which single tree to build}

\item{...}{further arguments passed to or from other methods}
}
\value{
a \code{list} of lists representation of the tree that can be 
inserted into a cell or pool
}
\description{
Builds an entire PFA list of lists based on a single gbm model tree
}
\examples{
dat <- data.frame(X1 = runif(100), 
                  X2 = rnorm(100))
dat$Y <- ((rexp(100,5) + 5 * dat$X1 - 4 * dat$X2) > 0)

bernoulli_model <- gbm::gbm(Y ~ X1 + X2, 
                            data = dat, 
                            distribution = 'bernoulli')
my_tree <- build_model(bernoulli_model, 1)
}
