% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-exotic.R
\name{auk_exotic}
\alias{auk_exotic}
\title{Filter the eBird data by exotic code}
\usage{
auk_exotic(x, exotic_code, replace = FALSE)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{exotic_code}{characterr; exotic codes to filter by. Note that an empty
string (""), meaning no exotic code, is used for native species.}

\item{replace}{logical; multiple calls to \code{auk_exotic()} are additive,
unless \code{replace = FALSE}, in which case the previous list of states to
filter by will be removed and replaced by that in the current call.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Exotic codes are applied to eBird observations when the species is believe to
be non-native to the given location. This function defines a filter for the
eBird Basic Dataset (EBD) to subset observations to one or more of the exotic
codes: "" (i.e. no code, meaning it is a native species), "N" (naturalized),
"P" (provisional), or "X" (escapee). This function only defines the filter
and, once all filters have been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to
call AWK and perform the filtering.
}
\examples{
# filter to only native observations
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_exotic(ebd, exotic_code = "")

# filter to native and naturalized observations
auk_exotic(ebd, exotic_code = c("", "N"))
}
\seealso{
Other filter: 
\code{\link{auk_bbox}()},
\code{\link{auk_bcr}()},
\code{\link{auk_breeding}()},
\code{\link{auk_complete}()},
\code{\link{auk_country}()},
\code{\link{auk_county}()},
\code{\link{auk_date}()},
\code{\link{auk_distance}()},
\code{\link{auk_duration}()},
\code{\link{auk_extent}()},
\code{\link{auk_filter}()},
\code{\link{auk_last_edited}()},
\code{\link{auk_observer}()},
\code{\link{auk_project}()},
\code{\link{auk_protocol}()},
\code{\link{auk_species}()},
\code{\link{auk_state}()},
\code{\link{auk_time}()},
\code{\link{auk_year}()}
}
\concept{filter}
