% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-ebd-version.r
\name{auk_ebd_version}
\alias{auk_ebd_version}
\title{Get the EBD version and associated taxonomy version}
\usage{
auk_ebd_version(x, check_exists = TRUE)
}
\arguments{
\item{x}{filename of EBD of sampling event data file, \code{auk_ebd} object, or
\code{auk_sampling} object.}

\item{check_exists}{logical; should the file be checked for existence before
processing. If \code{check_exists = TRUE} and the file does not exists, the
function will raise an error.}
}
\value{
A list with two elements:
\itemize{
\item \code{ebd_version}: a date object specifying the release date of the EBD.
\item \code{taxonomy_version}: the year of the taxonomy used in this EBD.
}

Both elements will be NA if an EBD version cannot be extracted from the
filename.
}
\description{
Based on the filename of eBird Basic Dataset (EBD) or sampling event data,
determine the version (i.e. release date) of this EBD. Also determine the
corresponding taxonomy version. The eBird taxonomy is updated annually in
August.
}
\examples{
auk_ebd_version("ebd_relAug-2018.txt", check_exists = FALSE)
}
\seealso{
Other helpers: \code{\link{auk_version}},
  \code{\link{ebird_species}},
  \code{\link{get_ebird_taxonomy}}
}
\concept{helpers}
