% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-time.r
\name{auk_time}
\alias{auk_time}
\title{Filter the EBD by checklist start time}
\usage{
auk_time(x, time)
}
\arguments{
\item{x}{\code{auk_ebd} object; reference to EBD file created by \code{\link[=auk_ebd]{auk_ebd()}}.}

\item{time}{character; 2 element character vector giving the range of times
in 24 hour format, e.g. \code{"06:30"} or \code{"16:22"}.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on a range of start
times for the checklist. This function only defines the filter and, once all
filters have been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and
perform the filtering.
}
\examples{
# only keep checklists started between 6 and 8 in the morning
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_time(time = c("06:00", "08:00"))
}
