% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strj-japanese.R
\name{strj_katakanize}
\alias{strj_katakanize}
\title{Katakanize Japanese characters}
\usage{
strj_katakanize(text)
}
\arguments{
\item{text}{Character vector.}
}
\value{
A character vector.
}
\description{
Converts Japanese hiragana to katakana.
It is almost similar to \code{stringi::stri_trans_general(text, "hira-kana")},
however, this implementation can also handle some additional symbols
such as Japanese kana ligature (aka. goryaku-gana).
}
\examples{
strj_katakanize(
  c(
    paste0(
      "\u3042\u306e\u30a4\u30fc\u30cf\u30c8",
      "\u30fc\u30f4\u30a9\u306e\u3059\u304d",
      "\u3068\u304a\u3063\u305f\u98a8"
    ),
    "\u672c\u65e5\u309f\u304b\u304d\u6c37\u89e3\u7981"
  )
)
}
