% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_to_description.R
\name{att_to_desc_from_is}
\alias{att_to_desc_from_is}
\title{Amend DESCRIPTION with dependencies from imports and suggests package list}
\usage{
att_to_desc_from_is(
  path.d = "DESCRIPTION",
  imports = NULL,
  suggests = NULL,
  check_if_suggests_is_installed = TRUE,
  normalize = TRUE,
  must.exist = TRUE
)
}
\arguments{
\item{path.d}{path to description file.}

\item{imports}{character vector of package names to add in Imports section}

\item{suggests}{character vector of package names to add in Suggests section}

\item{check_if_suggests_is_installed}{Logical. Whether to require that packages in the Suggests section are installed.}

\item{normalize}{Logical. Whether to normalize the DESCRIPTION file. See \code{\link[desc:desc_normalize]{desc::desc_normalize()}}}

\item{must.exist}{Logical. If TRUE then an error is given if packages do not exist
within installed packages. If NA, a warning.}
}
\value{
Fill in Description file
}
\description{
Amend DESCRIPTION with dependencies from imports and suggests package list
}
\details{
\code{must.exist} is better set to \code{TRUE} during package development.
This stops the process when a package does not exists on your system.
This avoids check errors with typos in package names in DESCRIPTION.
When used in CI to discover dependencies, for a bookdown for instance,
you may want to set to \code{FALSE} (no message at all) or \code{NA} (warning for not installed).
}
\examples{
tmpdir <- tempfile(pattern = "descfromis")
dir.create(tmpdir)
file.copy(system.file("dummypackage",package = "attachment"), tmpdir,
 recursive = TRUE)
dummypackage <- file.path(tmpdir, "dummypackage")
# browseURL(dummypackage)
att_to_desc_from_is(path.d = file.path(dummypackage, "DESCRIPTION"),
imports = c("magrittr", "attachment"), suggests = c("knitr"))

# In combination with other functions
att_to_desc_from_is(path.d = file.path(dummypackage, "DESCRIPTION"),
imports = att_from_rscripts(file.path(dummypackage, "R")),
suggests = att_from_rmds(file.path(dummypackage, "vignettes")))

# Clean temp files after this example
unlink(tmpdir, recursive = TRUE)
}
