% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atalp.R
\name{atalp}
\alias{atalp}
\title{Automated Test Assembly via Linear Constrained Programming}
\usage{
atalp( ipool,
      id,
      constraints,
      refine = FALSE,
      permutate = FALSE,
      sorttimes = 999,
      tieselect = -1,
      type = "const",
      verbose = TRUE,
      aprioriadd = NA,
      posthocadd = NA )
}
\arguments{
\item{ipool}{Item by characteristic (property) metadata pool.}

\item{id}{Name of unique item identifier.}

\item{constraints}{Complex list object identifying the constraints to be applied in the ATA (see \code{makeconstobj} for guided process).}

\item{refine}{Creates a final test form from permutated solutions, refined to attempt a deviation balance between the observed form and the constraints. Option only effective if \code{permutate} is \code{TRUE} and \code{type = const} in which the constraint weights have meaning; Default is \code{FALSE}.}

\item{permutate}{Requests the test form to be assembled by resorting (\code{sorttimes}) the metadata and selecting the most frequently occurring item combination satisfying the constraints. Relevant only for \code{type = const}; Default is \code{FALSE}.}

\item{sorttimes}{Number of how often the original input metadata should be resorted. Only functional if \code{permutate} is \code{TRUE} and \code{type = const}; default \code{999}, so that \code{sorttimes} + main analysis account for a total of 1,000 selection versions.}

\item{tieselect}{How should tied items be resolved: -1 (default) - do not manipulate items (which allows for identically functioning items to be included), 1 - select the first item in the list of candidates (sensitive to data sorting); not applicable for situations with all categorical constraints only, 0 - randomly select candidate; not applicable for situations with all categorical constraints only.}

\item{type}{Type of objective function: \code{const} - constraint based only (default), \code{parmin} - constraint + minimum non-categorical parameter combination, \code{parmax} - constraint + maximum non-categorical parameter combination.}

\item{verbose}{Should progress be printed to the console? Default \code{TRUE}.}

\item{aprioriadd}{Force item addition (via IDs) to test form before ATA, which affects item selection and constraint attainment success (currently not available).}

\item{posthocadd}{Force item addition (via IDs) to test form after ATA, which affects final form specifications (currently not available).}
}
\value{
A complex list object with test assembly specific estimates:
\item{objective}{Constrained objective function value.}
\item{items_removed}{Removed items from item pool when \code{tieselect} is not \code{-1}.}
\item{excluded}{Items from pool excluded.}
\item{excluded_set}{Item sets excluded. Only included if input \code{constobj} includes a \code{set_id}.}
\item{included}{Items from pool included in new test form.}
\item{included_set}{Item sets from pool included in new test form. Only included if input \code{constobj} includes a \code{set_id}.}
\item{final_ids}{Final item ids in the test form.}
\item{final_setids}{Final set ids in the test form. Only included if input \code{constobj} includes a \code{set_id}.}
}
\description{
Ingests item metadata jointly with target test form constraints, and can be parametarized to uses either Boolean (0-1) Integer Linear Programming (ILP) or Mixed Integer Linear Programming (MILP) to construct a test form based on the desired objectives. When MILP is desired the selection of the objective function type should be changed.
}
\examples{
# Specifying constraints
constin <- list(
  nI = 5,                                     # Number of items on the future test
  nC = 4,                                     # Number of constraints to be satisfied
  nameC = c("Content_A","Content_B","p","iSx"), # Name of constraint; must be numeric and must
  # reflect variable name in input
  lowerC = c(2, 3, 3.00, 0.50),               # Lower bound total constraint value on ATA form
  upperC = c(2, 3, 3.50, 0.60),               # Upper bound total constraint value on ATA form
  wC = c(1, 1, 1, 1),                         # Constraint weight used for weighted sum of
                                              # (positive) deviations St
  set_id = NA                                 # Aggregation ID for units / sets 
)

# Running atalp
testLP <- atalp(ipool = metadata_example,
                id = "Item",
                constraints = constin)

# Summary of results
summary(testLP)

}
\references{
Chen, P. (2017). Should we stop developing heuristics and only rely on mixed integer programming solvers in automated test assembly? Applied Psychological Measurement, 41, 227-240.

Diao, Q., & van der Linden, W. J. (2011). Automated test assembly using lp_Solve Version 5.5 in R. Applied Psychological Measurement, 35, 398-409.

Shao, C., Liu, S., Yang, H., & Tsai, T. (2019). Automated test assembly using SAS operations research software in a medical licensing examination. Applied Psychological Measurement, 00, 1-15.

van der Linden, W. J. (2005). A comparison of item-selection methods for adaptive tests with content constraints. Journal of Educational Measurement, 42, 283-302.
}
\author{
Michael Chajewski (mchajewski@hotmail.com), Gulsah Gurkan (gurkangulsah@gmail.com)
}
\keyword{"assessment}
\keyword{"automatest}
\keyword{"test}
\keyword{assembly"}
\keyword{ata}
\keyword{automatest_test_assembly}
\keyword{form"}
\keyword{lp}
\keyword{test}
\keyword{test_form}
\keyword{test_via_lp}
\keyword{testform}
