% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_plot_distrib_2D.R
\name{f_plot_distrib_2D}
\alias{f_plot_distrib_2D}
\title{Plot of historical distributions in 2D}
\usage{
f_plot_distrib_2D(
  m_param_histo,
  type_function,
  database,
  x_lab,
  y_lab,
  x_min,
  x_max
)
}
\arguments{
\item{m_param_histo}{Numeric matrix containing the parameters of the f_param_histo function}

\item{type_function}{String argument specifying the distribution type ("gaussian" or "skew-t")}

\item{database}{Dataframe containing the data, with dates in the first column and dependent variable in the second column}

\item{x_lab}{String optional argument for the x axis title (default value = x)}

\item{y_lab}{String optionalargument for the y axis title (default value = y)}

\item{x_min}{Numeric optional argument (default value = -15)}

\item{x_max}{Numeric optional argument (default value = 10)}
}
\value{
A plot of historical distributions with the median, four quantiles (5th, 25th, 75th, 95th) and the realized dependent variable.
}
\description{
This function allows to create a plot in 2D of historical distributions.
}
\examples{
# Import data
data(data_US)

data(data_param_histo)

results_plot_2D <- f_plot_distrib_2D(m_param_histo=data_param_histo,
type_function="skew-t",
database=data_US,
x_lab="US GDP variation",
y_lab="Year")

}
