% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cps.R
\name{delay}
\alias{delay}
\title{Asynchronous pause.}
\usage{
delay(secs, expr = NULL)
}
\arguments{
\item{secs}{The promise will resolve after at least this many seconds.}

\item{expr}{The value to resolve with; will be forced after the delay.}
}
\value{
An object with class \link[promises:promise]{"promise"}.
}
\description{
"delay" returns a promise which resolves only after the specified
number of seconds. This uses the R event loop via \link{later}.
In an \verb{[async]} construct you can use \code{await(delay(secs))} to yield
control, for example if you need to poll in a loop.
}
\examples{
# print a message after a few seconds
async({await(delay(10)); cat("Time's up!\n")})
}
