/*
 * Decompiled with CFR 0.152.
 */
package asymmetry;

import asymmetry.slidevector;

public class Asymmetry {
    double[][] X;
    double[][] BMAT;
    double[][] diss;
    int dim;
    int nobj;

    public static void main(String[] args) {
        Asymmetry mds = new Asymmetry();
        mds.smacof();
        System.out.println(mds.info());
        slidevector uf = new slidevector();
        uf.smacof();
        uf.info();
    }

    public void smacof() {
        int j;
        int i;
        this.nobj = 8;
        this.dim = 2;
        this.BMAT = new double[this.nobj][this.nobj];
        this.X = new double[this.nobj][this.dim];
        this.diss = new double[this.nobj][this.nobj];
        for (i = 0; i < this.nobj; ++i) {
            for (j = 0; j < i; ++j) {
                this.diss[i][j] = Math.random();
                this.diss[j][i] = this.diss[i][j];
            }
        }
        for (i = 0; i < this.nobj; ++i) {
            for (j = 0; j < this.dim; ++j) {
                this.X[i][j] = Math.random();
            }
        }
    }

    public double[][] BMAT(double[][] data, double[][] X, double[][] BMAT, int dim, int nobj) {
        int j;
        int i;
        for (i = 0; i < nobj; ++i) {
            for (j = 0; j < nobj; ++j) {
                BMAT[i][j] = Asymmetry.distance(X, dim, i, j) > 1.0E-16 ? -1.0 * data[i][j] / Asymmetry.distance(X, dim, i, j) : 0.0;
            }
        }
        for (i = 0; i < nobj; ++i) {
            BMAT[i][i] = 0.0;
        }
        for (i = 0; i < nobj; ++i) {
            for (j = 0; j < nobj; ++j) {
                if (i == j) continue;
                double[] dArray = BMAT[i];
                int n = i;
                dArray[n] = dArray[n] - BMAT[i][j];
            }
        }
        return BMAT;
    }

    public double[][] update(double[][] BMAT, double[][] X, int dim, int nobj) {
        double[][] XT = new double[nobj][dim];
        for (int i = 0; i < nobj; ++i) {
            for (int j = 0; j < dim; ++j) {
                for (int k = 0; k < nobj; ++k) {
                    double[] dArray = XT[i];
                    int n = j;
                    dArray[n] = dArray[n] + BMAT[i][k] * X[k][j];
                }
            }
        }
        return XT;
    }

    public double[][] weight(double[][] X, int dim, int nobj) {
        for (int i = 0; i < nobj; ++i) {
            for (int j = 0; j < dim; ++j) {
                X[i][j] = X[i][j] / (double)nobj;
            }
        }
        return X;
    }

    public String info() {
        String info = new String("hello from smacof 6");
        for (int i = 0; i < 12; ++i) {
            this.BMAT = this.BMAT(this.diss, this.X, this.BMAT, this.dim, this.nobj);
            this.X = this.update(this.BMAT, this.X, this.dim, this.nobj);
            this.X = this.weight(this.X, this.dim, this.nobj);
            System.out.println(" stress " + this.stress(this.diss, this.X, this.dim, this.nobj));
        }
        for (int j = 0; j < this.nobj; ++j) {
            System.out.print(" xcoord 1 " + this.X[j][0]);
            System.out.println(" xcoord 2 " + this.X[j][1]);
        }
        return info;
    }

    public double stress(double[][] diss, double[][] X, int dim, int nobj) {
        double stress = 0.0;
        for (int i = 0; i < nobj; ++i) {
            for (int j = 0; j < nobj; ++j) {
                stress += Math.pow(diss[i][j] - Asymmetry.distance(X, dim, i, j), 2.0);
            }
        }
        return stress;
    }

    public double[][] getConfiguration() {
        return this.X;
    }

    public static double distance(double[][] X, int dim, int i, int j) {
        double result = 0.0;
        for (int k = 0; k < dim; ++k) {
            result += Math.pow(X[i][k] - X[j][k], 2.0);
        }
        return Math.sqrt(result);
    }
}

