% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-data.R, R/is-data.R
\name{assert_all_are_honorifics}
\alias{assert_all_are_honorifics}
\alias{assert_any_are_honorifics}
\alias{is_honorific}
\title{Is the string an honorific?}
\usage{
assert_all_are_honorifics(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_honorifics(x, na_ignore = FALSE,
  severity = getOption("assertive.severity", "stop"))

is_honorific(x)
}
\arguments{
\item{x}{Input to check.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
\code{is_honorific} returns \code{TRUE} if the input string contains
a valid UK postcode. The {assert_*} function returns nothing but throws an
error when the \code{is_*} function returns \code{FALSE}.
}
\description{
Checks that the input contains honorifics (a.k.a. titles
or salutations).
}
\note{
Single full stops (periods) following a word boundary
and preceding a space or the end of the string are stripped.
Case is ignored.  There is no formal list of official salutations,
so this should only be used as a guide, rather than giving a
definitive result.  Especially note that cultural conventions
differ across the world and this function has a UK bias.
}
\examples{
x <- c("Mr", "MR", "mr.", "Mister", "masTer", "Mr!", "M.r", ".Mr")
is_honorific(x)
}
\references{
Many possibilities borrowed from the Salutation dropdown on
the MathWorks account creation page.
\url{https://www.mathworks.com/accesslogin/createProfile.do}
}

