% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-code.R, R/is-code.R
\name{assert_all_are_existing}
\alias{assert_all_are_existing}
\alias{assert_any_are_existing}
\alias{is_existing}
\title{Does the variable exist?}
\usage{
assert_all_are_existing(x, envir = parent.frame(), inherits = TRUE,
  severity = getOption("assertive.severity", "stop"))

assert_any_are_existing(x, envir = parent.frame(), inherits = TRUE,
  severity = getOption("assertive.severity", "stop"))

is_existing(x, envir = parent.frame(), inherits = TRUE,
  .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{envir}{Passed to \code{exists}.}

\item{inherits}{Passed to \code{exists}.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_existing} is a vectorized wrapper to \code{exists},
providing more information on failure (and with a simplified interface).
The \code{assert_*} functions return nothing but throw an error if
\code{is_existing} returns \code{FALSE}.
}
\description{
Checks to see if the input variables exist.
}
\examples{
e <- new.env()
e$x <- 1
e$y <- 2
assert_all_are_existing(c("x", "y"), envir = e)
#These examples should fail.
assertive.base::dont_stop(assert_all_are_existing(c("x", "z"), envir = e))
}
\seealso{
\code{\link[base]{exists}}.
}

