% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utils.R
\name{merge.list}
\alias{merge.list}
\title{Merge two lists}
\usage{
\method{merge}{list}(x, y, warn_on_dupes = TRUE, ...)
}
\arguments{
\item{x}{A list.}

\item{y}{A list.}

\item{warn_on_dupes}{\code{TRUE} or \code{FALSE}.  Should a warning be given
if both \code{x} and \code{y} have elements with the same name.  See note.}

\item{...}{Ignored.}
}
\value{
A list, combining elements from \code{x} and \code{y}.
}
\description{
Merges two lists, taking duplicated elements from the first list.
}
\note{
In the event of elements that are duplicated between \code{x} and
\code{y}, the versions from \code{x} are used.
}
\examples{
merge(
  list(foo = 1, bar = 2, baz = 3),
  list(foo = 4, baz = 5, quux = 6)
)
}
\seealso{
\code{\link{merge_dots_with_list}}, \code{\link[base]{merge}}
}

