% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_component.R
\name{pk_elimination_linear_nl}
\alias{pk_elimination_linear_nl}
\title{PK elimination linear & nonlinear}
\usage{
pk_elimination_linear_nl(
  prm_cllin = prm_log_normal("cllin", median = 50, var_log = 0.1),
  prm_clmm = prm_log_normal("clmm", median = 25, var_log = 0.1),
  prm_km = prm_log_normal("km", median = 0.5, var_log = 0.1),
  prm_vmax = NULL
)
}
\arguments{
\item{prm_cllin}{Parameter model for the linear clearance}

\item{prm_clmm}{Parameter model for the non-linear clearance}

\item{prm_km}{Parameter model for KM (the half-maximal concentration)}

\item{prm_vmax}{Parameter model for Vmax (the maximal elimination rate)}
}
\value{
A building block of type 'pk_component'
}
\description{
This building block declares a mixed linear and nonlinear elimination component for a pharmacokinetic model.
}
\details{
\subsection{PK components}{

PK components can be added to a \link{pk_model} and exist in
three different types: absorption, distribution, and elimination. The
absorption component is optional, distribution and elimination are not
and need to be added for the PK model to be valid.

A PK model can only have one component of each type and adding a
component with an already existing type will replace the previous
definition. For example, the distribution component will be a two
compartment model in the following snippet:\preformatted{pkm <- pk_model() +
  pk_absorption_fo() +
  pk_distribution_1cmp() +
  pk_distribution_2cmp() +
  pk_elimination_linear() +
  obs_additive(conc~C["central"]) 
pkm
}
}

\subsection{Parameter models}{

All PK component functions allow the specification of the parameter
model via their arguments. Arguments that refer to a parameter start
with the prefix \code{prm_}. The default parameter model can be deduced from
the default arguments in the usage section of the help entry. The
parameter name, specified via the \verb{name=} argument of the parameter
model building block allows the renaming of the model parameters.

For example, the parameter \verb{prm_vc=} refers to the central volume of
distribution parameter in the one compartment distribution PK component
and the default parameter model is a log-normal distribution. The
following code block specifies a normal distribution parameter model and
names the parameter \code{v}:\preformatted{pk_distribution_1cmp(
    prm_vc = prm_normal("v", mean = 50, var = 25)
)
}
}
}
\seealso{
\code{\link[=pk_model]{pk_model()}} for the creation of PK models

Other elimination components: 
\code{\link{pk_elimination_linear}()},
\code{\link{pk_elimination_nl}()}
}
\concept{elimination components}
