% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/asdreader.r
\name{get_spectra}
\alias{get_spectra}
\title{Reads reflectance from ASD file}
\usage{
get_spectra(f, type = "reflectance")
}
\arguments{
\item{f}{a vector of paths to ASD file(s)}

\item{type}{a character vector, which type of spectra to return. \code{"reflectance"}, \code{"raw"}, \code{"white_reference"} are currently supported}
}
\value{
a matrix of the spectrum contained in the ASD file(s)
}
\description{
Reads reflectance from ASD file
}
\examples{
# Get the path to the demo file

asd_fn <- asd_file()
print(asd_fn)

# Example with one file name

m1 <- get_spectra(asd_fn)
matplot(t(m1), type = 'l')

# Example with a vector of file names

asd_fns <- rep(asd_fn, times = 4)
print(asd_fns) # (in this case, 4 times the same file)

m2 <- get_spectra(asd_fns)
matplot(t(m2), type = 'l')
}
\author{
Pierre Roudier
}

