% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_fun.R
\name{logistic_fun}
\alias{logistic_fun}
\title{Function to fit logistic model}
\usage{
logistic_fun(Dose, E0 = 0, EC50 = 50, Emax = 1, rc = 5)
}
\arguments{
\item{Dose}{The dose value to calculate at}

\item{E0}{Effect at time 0}

\item{EC50}{50\% of maximum effect}

\item{Emax}{Maximum effect}

\item{rc}{rate constant}
}
\value{
Numeric value/vector representing the response value.
}
\description{
Simple logistic function as used in Ascent training materials. Note:  This function has be renamed using tidyverse-style snake_case
naming conventions. However the original name of the function has been kept to ensure backwards compatibility with the book SAMS
Teach Yourself R in 24 Hours (ISBN: 978-0-672-33848-9).
}
\examples{
logistic_fun(Dose = 50)

}
