% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/associations.R, R/plot.R
\docType{class}
\name{associations-class}
\alias{associations-class}
\alias{associations}
\alias{initialize,associations-method}
\alias{show,associations-method}
\alias{t,associations-method}
\alias{summary.associations-class}
\alias{quality,associations-method}
\alias{quality}
\alias{quality<-,associations-method}
\alias{quality<-}
\alias{info,associations-method}
\alias{info}
\alias{info<-,associations-method}
\alias{info<-}
\alias{head,associations-method}
\alias{head}
\alias{tail,associations-method}
\alias{tail}
\alias{items,associations-method}
\alias{items}
\alias{items<-}
\alias{length,associations-method}
\alias{labels,associations-method}
\alias{plot}
\alias{plot.associations}
\alias{plot.itemMatrix}
\title{Class associations --- A Set of Associations}
\usage{
\S4method{quality}{associations}(x)

\S4method{quality}{associations}(x) <- value

\S4method{info}{associations}(x)

\S4method{info}{associations}(x) <- value

\S4method{head}{associations}(x, n = 6L, by = NULL, decreasing = TRUE, ...)

\S4method{tail}{associations}(x, n = 6L, by = NULL, decreasing = TRUE, ...)

\S4method{items}{associations}(x)

\S4method{length}{associations}(x)

\S4method{labels}{associations}(object)
}
\arguments{
\item{x, object}{the object.}

\item{value}{the replacement value.}

\item{n}{number of elements}

\item{by}{sort by this interest measure}

\item{decreasing}{sort in decreasing order?}

\item{...}{further arguments.}
}
\description{
The \code{associations} class is a virtual class which is extended to
represent mining result (e.g., sets of \link{itemsets} or
\link{rules}). The class defines some common methods for its subclasses.
}
\details{
The implementations of \code{associations} store itemsets (e.g., the LHS and
RHS of a rule) as objects of class \link{itemMatrix} (i.e., sparse
binary matrices). Quality measures (e.g., support) are stored in a
data.frame accessible via method \code{quality()}.

See Sections Functions and See Also to see all available methods.

\strong{Note:} Associations can store multisets with duplicated elements. Duplicated
elements can result from combining several sets of associations.  Use
\code{\link[=unique]{unique()}} to remove duplicate associations.
}
\section{Functions}{
\itemize{
\item \code{quality(associations)}: returns the quality data.frame.

\item \code{quality(associations) <- value}: replaces the quality data.frame. The lengths of the vectors in the data.frame have to equal the number of associations in the set.

\item \code{info(associations)}: returns the info list.

\item \code{info(associations) <- value}: replaces the info list.

\item \code{head(associations)}: returns the first n associations.

\item \code{tail(associations)}: returns the last n associations.

\item \code{items(associations)}: dummy method. This method has to be implemented by all subclasses of associations and return the items which make up each association as an object of class \link{itemMatrix}.

\item \code{length(associations)}: dummy method. This method has to be implemented by all subclasses of associations and return the number of elements in the association.

\item \code{labels(associations)}: dummy method. This method has to be implemented by all subclasses of associations and return a vector of length(object) of labels for the elements in the association.

}}
\section{Slots}{

\describe{
\item{\code{quality}}{a data.frame}

\item{\code{info}}{a list}
}}

\section{Objects from the Class}{

A virtual class: No objects may be created
from it.
}

\seealso{
Subclasses: \link{rules}, \link{itemsets}

Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{rules-class}},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\keyword{classes}
