% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossTable.R
\name{crossTable}
\alias{crossTable}
\alias{crossTable,itemMatrix-method}
\title{Cross-tabulate joint occurrences across pairs of items}
\usage{
crossTable(x, ...)

\S4method{crossTable}{itemMatrix}(
  x,
  measure = c("count", "support", "probability", "lift"),
  sort = FALSE
)
}
\arguments{
\item{x}{object to be cross-tabulated (\link{transactions} or
\link{itemMatrix}).}

\item{...}{additional arguments.}

\item{measure}{measure to return. Default is co-occurrence counts.}

\item{sort}{sort the items by support.}
}
\value{
A symmetric matrix of n x n, where n is the number of items times
in \code{x}. The matrix contains the co-occurrence counts between pairs of
items.
}
\description{
Provides the generic function \code{crossTable()} and a method to
cross-tabulate joint occurrences across all pairs of items.
}
\examples{
data("Groceries")

ct <- crossTable(Groceries, sort = TRUE)
ct[1:5, 1:5]

sp <- crossTable(Groceries, measure = "support", sort = TRUE)
sp[1:5, 1:5]

lift <- crossTable(Groceries, measure = "lift", sort = TRUE)
lift[1:5, 1:5]

}
\seealso{
Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemFrequency}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{itemMatrix and transactions functions}
\keyword{models}
