# This is a poor mans implementation which mines all rules and
# then filters the rules which do not stam from the itemsets
  

setMethod("ruleInduction",  signature(x = "itemsets"),
function(x, transactions, confidence = 0.8, verbose = FALSE) {

  nItems <- dim(transactions)[2]
  if (nItems != dim(items(x))[2])
  	stop("Dimensions of x and transactions do not match!")
 
  # only need to mine items which occur in x
  items.involved <-  itemFrequency(items(x)) > 0
  names(items.involved) <- NULL
  
  transactions.sub <- transactions[, items.involved] 

  # itemset sizes
  isetsSize <-  size(x)
  
  # find minimal support and mine all rules
  # note: minSupport is reduced by epsilon so we get the rules
  #	with support == min support in x
  minSupport <-  min(quality(x)$support) - 1/length(transactions)

  
  rules <- apriori(transactions.sub,  parameter = list(support = minSupport,
 	confidence = confidence, target = "rules", 
	minlen = min(isetsSize), 
	maxlen = max(isetsSize)),
	control = list(verbose = verbose))
  
  # find rules which were generated by the itemsets
  isets <- LIST(items(x)[, items.involved], decode = FALSE)
  generatingIsets <- LIST(items(rules), decode = FALSE)

 
  # filter rules which do not match a itemset
  if (verbose) cat("\n filter rules: ")

  ### make a vector with false
  take <- logical(length = length(rules))
 
  for (i in 1 : length(generatingIsets)) {
    if (verbose) cat(paste(i),"")
    #for (j in 1: length(isets)) {
    ### we only need to compare itemsets of same length
    for (j in which(isetsSize == length(generatingIsets[[i]]))) {
       if (setequal(generatingIsets[[i]], isets[[j]])) {
          take[i] <- TRUE
	  break
       }
    }
  }
    
  if (verbose) cat("\n")
  
  rules <- rules[take]

  # expand items back to full space
  # -1 since indices in dgCMatix start with 0 
  items.index <- as.integer(which(items.involved) - 1)
 
  # fix dim
  rules@lhs@data@Dim[1] <- nItems
  rules@rhs@data@Dim[1] <- nItems
    
  # fix column indices
  # +1 since indices in dgCMatix start with 0
  rules@lhs@data@i <- items.index[(rules@lhs@data@i +1)]
  rules@rhs@data@i <- items.index[(rules@rhs@data@i +1)]

  # fix item labels
  rules@lhs@itemInfo <- itemInfo(transactions)
  rules@rhs@itemInfo <- itemInfo(transactions)

  # return found rules
  rules 
})




