context("Permutations with replacement")

test_that("Permutations with replacement - npermutations", {
    expect_equal(npermutations(5, 3, replace = TRUE), 125)
    expect_equal(npermutations(x = LETTERS[1:5], k = 3, replace = TRUE), 125)
    expect_error(npermutations(10, 10, replace = TRUE), "integer overflow")
    expect_error(npermutations(x = LETTERS[1:10], k = 10, replace = TRUE), "integer overflow")
    expect_equal(npermutations(10, 10, replace = TRUE, bigz = TRUE), gmp::as.bigz("10000000000"))
    expect_equal(npermutations(10, 0, replace = TRUE), 1)
    expect_equal(npermutations(2, 3, replace = TRUE), 8)
    expect_error(npermutations(6, -1, replace = TRUE), "expect non-negative integer")
    expect_error(npermutations(6, 1.5, replace = TRUE), "expect non-negative integer")

    expect_equal(npermutations(0, 0, replace = TRUE), 1)
    expect_equal(npermutations(0, 1, replace = TRUE), 0)
})

test_that("Permutations with replacement - permutations", {
    perm <- permutations(5, 3, replace= TRUE)
    expect_equal(nrow(perm), 125)
    expect_equal(ncol(perm), 3)
    expect_equal(perm[1, ], rep(1, 3))
    expect_equal(perm[125, ], rep(5, 3))

    perm <- permutations(5, 3, replace= TRUE, type = "r")
    expect_equal(nrow(perm), 125)
    expect_equal(ncol(perm), 3)
    expect_equal(perm[1, ], rep(1, 3))
    expect_equal(perm[125, ], rep(5, 3))

    perm <- permutations(5, 3, replace= TRUE, type = "c")
    expect_equal(ncol(perm), 125)
    expect_equal(nrow(perm), 3)
    expect_equal(perm[, 1], rep(1, 3))
    expect_equal(perm[, 125], rep(5, 3))

    perm <- permutations(5, 3, replace= TRUE, type = "l")
    expect_equal(length(perm), 125)
    expect_equal(perm[[1]], rep(1, 3))
    expect_equal(perm[[125]], rep(5, 3))

    perm <- permutations(x = LETTERS[1:5], k = 3, replace= TRUE)
    expect_equal(nrow(perm), 125)
    expect_equal(ncol(perm), 3)
    expect_equal(perm[1, ], LETTERS[rep(1, 3)])
    expect_equal(perm[125, ], LETTERS[rep(5, 3)])

    expect_error(permutations(10, 10, replace = TRUE), "too many results")
    expect_error(permutations(5, -1, replace= TRUE), "expect non-negative integer")
    expect_error(permutations(5, 1.5, replace= TRUE), "expect non-negative integer")
    expect_equal(dim(permutations(5, 0, replace= TRUE)), c(1, 0))
    expect_equal(dim(permutations(2, 3, replace= TRUE)), c(8, 3))
    expect_equal(dim(permutations(0, 0, replace= TRUE)), c(1, 0))
    expect_equal(dim(permutations(0, 1, replace= TRUE)), c(0, 1))
})

test_that("Permutations with replacement - ipermutations", {
    iperm <- ipermutations(5, 3, replace= TRUE)
    perm <- permutations(5, 3, replace= TRUE)
    expect_equal(iperm$collect(), perm)
    expect_equal(iperm$getnext(), rep(1, 3))
    expect_equal(iperm$getnext(), c(1, 1, 2))
    iperm$getnext(120)
    expect_equal(nrow(iperm$getnext(10)), 3)
    expect_equal(iperm$getnext(), NULL)

    perm <- permutations(5, 3, replace= TRUE, type = "r")
    expect_equal(iperm$collect(type = "r"), perm)
    expect_equal(iperm$getnext(type = "r"), t(rep(1, 3)))
    expect_equal(iperm$getnext(type = "r"), t(c(1, 1, 2)))
    iperm$getnext(120, type = "r")
    expect_equal(nrow(iperm$getnext(10, type = "r")), 3)
    expect_equal(iperm$getnext(type = "r"), NULL)

    perm <- permutations(5, 3, replace= TRUE, type = "c")
    expect_equal(iperm$collect(type = "c"), perm)
    expect_equal(iperm$getnext(type = "c"), t(t(rep(1, 3))))
    expect_equal(iperm$getnext(type = "c"), t(t(c(1, 1, 2))))
    iperm$getnext(120, type = "c")
    expect_equal(ncol(iperm$getnext(10, type = "c")), 3)
    expect_equal(iperm$getnext(type = "c"), NULL)

    perm <- permutations(5, 3, replace= TRUE, type = "l")
    expect_equal(iperm$collect(type = "l"), perm)
    expect_equal(iperm$getnext(type = "l"), list(rep(1, 3)))
    expect_equal(iperm$getnext(type = "l"), list(c(1, 1, 2)))
    iperm$getnext(120, type = "l")
    expect_equal(length(iperm$getnext(10, type = "l")), 3)
    expect_equal(iperm$getnext(type = "l"), NULL)

    iperm <- ipermutations(5, 0, replace= TRUE)
    expect_equal(dim(iperm$collect()), c(1, 0))
    expect_equal(length(iperm$getnext()), 0)
    expect_equal(iperm$getnext(), NULL)
    iperm <- ipermutations(2, 3, replace= TRUE)
    expect_equal(nrow(iperm$collect()), 8)
    expect_error(ipermutations(5, -1, replace= TRUE), "expect non-negative integer")
    expect_error(ipermutations(5, 1.5, replace= TRUE), "expect non-negative integer")
})
