% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/compact.R
\docType{methods}
\name{compact}
\alias{compact}
\alias{compact-method}
\alias{compact_cols}
\alias{compact_cols-method}
\alias{compact_rows}
\alias{compact_rows-method}
\alias{compact,ANY-method}
\alias{compact_cols,ANY-method}
\alias{compact_rows,ANY-method}
\title{Remove empty rows/columns}
\usage{
compact(x, ...)

compact_cols(x, ...)

compact_rows(x, ...)

\S4method{compact}{ANY}(x, margin = 1)

\S4method{compact_cols}{ANY}(x)

\S4method{compact_rows}{ANY}(x)
}
\arguments{
\item{x}{An object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}

\item{margin}{A vector giving the subscripts which the function will be
applied over (\code{1} indicates rows, \code{2} indicates columns).}
}
\description{
Removes empty rows/columns in an array-like object using a predicate
function.
}
\details{
A row/column is empty if it contains only \code{NA}, zeros (if of type \code{numeric})
or zero length character strings (if of type \code{character}).
}
\examples{
## Create a count data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add NA
k <- sample(1:25, 3, FALSE)
X[k] <- NA
X

## Count missing values in rows
count(X, f = is.na, margin = 1)
## Count non-missing values in columns
count(X, f = is.na, margin = 2, negate = TRUE)

## Find row with NA
detect(X, f = is.na, margin = 1)
## Find column without any NA
detect(X, f = is.na, margin = 2, negate = TRUE, all = TRUE)

## Keep row without any NA
keep(X, f = is.na, margin = 1, negate = TRUE, all = TRUE)
## Keep row without any NA
keep(X, f = is.na, margin = 2, negate = TRUE, all = TRUE)

## Remove row with any NA
discard(X, f = is.na, margin = 1, all = FALSE)
## Remove column with any NA
discard(X, f = is.na, margin = 2, all = FALSE)

## Replace NA with zeros
replace_NA(X, value = 0)
}
\seealso{
Other data cleaning tools: 
\code{\link{count}()},
\code{\link{detect}()},
\code{\link{discard}()},
\code{\link{infinite}},
\code{\link{keep}()},
\code{\link{missing}},
\code{\link{zero}}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
