% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{interval_credible}
\alias{interval_credible}
\alias{interval_credible-method}
\alias{interval_credible,numeric-method}
\title{Bayesian Credible Interval}
\usage{
interval_credible(x, ...)

\S4method{interval_credible}{numeric}(x, level = 0.95)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector.}

\item{...}{Currently not used.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}
}
\value{
A three-columns \code{numeric} \code{\link{matrix}} giving the lower and upper boundaries
of the credible interval and associated probability.
}
\description{
Computes the shortest credible interval within which an unobserved parameter
value falls with a particular probability.
}
\examples{
## HDR of the Old Faithful eruption times
interval_hdr(faithful$eruptions)
}
\seealso{
Other summary statistics: 
\code{\link{confidence_binomial}()},
\code{\link{confidence_mean}()},
\code{\link{confidence_multinomial}()},
\code{\link{interval_hdr}()}
}
\author{
N. Frerebeau
}
\concept{summary statistics}
