% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{jackknife}
\alias{jackknife}
\alias{jackknife-method}
\alias{jackknife,numeric-method}
\title{Jackknife Estimation}
\usage{
jackknife(object, ...)

\S4method{jackknife}{numeric}(object, do, ...)
}
\arguments{
\item{object}{A \code{\link{numeric}} vector.}

\item{...}{Extra arguments passed to \code{do}.}

\item{do}{A \code{\link{function}} that takes \code{object} as an argument and returns a
single numeric value.}
}
\value{
Returns a named \code{numeric} vector with the following elements:
\describe{
\item{\code{mean}}{The jackknife estimate of mean of \code{do}.}
\item{\code{bias}}{The jackknife estimate of bias of \code{do}.}
\item{\code{error}}{he jackknife estimate of standard error of \code{do}.}
}
}
\description{
Jackknife Estimation
}
\examples{
## Jackknife
x <- rnorm(20)
jackknife(x, do = mean) # Sample mean
}
\seealso{
Other resampling methods: 
\code{\link{confidence}()}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
