% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/extract.R
\docType{methods}
\name{subset}
\alias{subset}
\alias{[<-,Matrix-method}
\alias{[,Matrix-method}
\alias{[[<-,Matrix-method}
\alias{[[,Matrix-method}
\title{Extract or Replace Parts of an Object}
\usage{
\S4method{[}{Matrix}(x, i, j) <- value

\S4method{[[}{Matrix}(x, i, j) <- value
}
\arguments{
\item{x}{An object from which to extract element(s) or in which to replace
element(s).}

\item{i, j}{Indices specifying elements to extract or replace. Indices are
\code{\link{numeric}}, \code{\link{integer}} or \code{\link{character}}
vectors or empty (missing) or \code{NULL}. Numeric values are coerced to
\code{\link{integer}} as by \code{\link{as.integer}} (and hence truncated
towards zero). Character vectors will be matched to the name of the
elements. An empty index (a comma separated blank) indicates that all
entries in that dimension are selected.}

\item{value}{A possible value for the element(s) of \code{x}.}
}
\value{
A subsetted object.
}
\description{
Operators acting on objects to extract or replace parts.
}
\examples{
## Create a count data matrix
A1 <- CountMatrix(data = sample(0:10, 100, TRUE), nrow = 10, ncol = 10)

## Access
get_id(A1)
dim(A1) # Get the matrix dimensions
colnames(A1) <- letters[11:20] # Set the column names
colnames(A1) # Get the column names
rownames(A1) <- LETTERS[1:10] # Set the row names
rownames(A1) # Get the rownames

## Subset
A1[[1]] # Get the first value
A1[, ] # Get all values
A1[1, ] # Get the first row
A1[c("A", "B", "C"), ] # Get the first three rows
A1[c("A", "B", "C"), 1] # Get the first three rows of the first column
A1[, 1, drop = FALSE] # Get the first column

## Coerce counts to relative frequencies
B <- as_abundance(A1)
## Row sums are internally stored before coercing to a frequency matrix
get_totals(B) # Get row sums
## This allows to restore the source data
A2 <- as_count(B)
all(A1 == A2)
## Coerce to a co-occurrence matrix
B <- as_occurrence(A1)
}
\seealso{
Other mutator: \code{\link{mutator}}
}
\author{
N. Frerebeau
}
\concept{mutator}
