% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_db.R
\name{local_db}
\alias{local_db}
\title{Connect to a local stand-alone database}
\usage{
local_db(
  dbdir = arkdb_dir(),
  driver = Sys.getenv("ARKDB_DRIVER"),
  readonly = FALSE
)
}
\arguments{
\item{dbdir}{Path to the database.}

\item{driver}{Default driver, one of "duckdb", "MonetDBLite", "RSQLite".
It will select the first one of those it finds available if a
driver is not set. This fallback can be overwritten either by explicit
argument or by setting the environmental variable \code{ARKDB_DRIVER}.}

\item{readonly}{Should the database be opened read-only? (duckdb only).
This allows multiple concurrent connections (e.g. from different R sessions)}
}
\value{
Returns a \verb{[DBIcoonection]} connection to the default duckdb database
}
\description{
This function will provide a connection to the best available database.
This function is a drop-in replacement for \verb{[DBI::dbConnect]} with behaviour
that makes it more subtle for R packages that need a database backend with
minimal complexity, as described in details.
}
\details{
This function provides several abstractions to \verb{[DBI::dbConnect]} to
provide a seamless backend for use inside other R packages.

First, this  provides a generic method that allows the use of a \verb{[RSQLite::SQLite]`` connection if nothing else is available, while being able to automatically select a much faster, more powerful backend from }\link[duckdb:duckdb]{duckdb::duckdb}`
if available.  An argument or environmental variable can be used to override this
to manually set a database endpoint for testing purposes.

Second, this function will cache the database connection in an R environment and
load that cache.  That means you can call \code{local_db()} as fast/frequently as you
like without causing errors that would occur by rapid calls to \verb{[DBI::dbConnect]}

Third, this function defaults to persistent storage location set by \verb{[rappdirs::user_data_dir]}
and configurable by setting the environmental variable \code{ARKDB_HOME}.  This allows
a package to provide persistent storage out-of-the-box, and easily switch that storage
to a temporary directory (e.g. for testing purposes, or custom user configuration) without
having to edit database calls directly.
}
\examples{
\donttest{
## OPTIONAL: you can first set an alternative home location,
## such as a temporary directory:
Sys.setenv(ARKDB_HOME=tempdir())

## Connect to the database:
db <- local_db()

}
}
