% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arfima_function.R
\name{distance}
\alias{distance}
\title{The distance between modes of an \code{arfima} fit.}
\usage{
distance(ans, p = 2, digits = 4)
}
\arguments{
\item{ans}{An object of class "arfima".}

\item{p}{The p in the p-norm to be used.}

\item{digits}{The number of digits to print.}
}
\value{
A list of two data frames: one with distances in operator space, the
second with distances in the transformed (PACF) space.
}
\description{
The distance between modes of an \code{arfima} fit.
}
\examples{

\dontrun{
set.seed(8564)
sim <- arfima.sim(1000, model = list(phi = c(0.2, 0.1), dfrac = 0.4, theta = 0.9))
fit <- arfima(sim, order = c(2, 0, 1))

fit

distance(fit)
}

}
\references{
Veenstra, J.Q. Persistence and Antipersistence:  Theory and
Software (PhD Thesis)
}
\author{
JQ (Justin) Veensta
}
\keyword{ts}
