\name{SeriesJ}
\alias{SeriesJ}
\docType{data}
\title{ Series J, Gas Furnace Data}
\description{
Gas furnace data, sampling interval 9 seconds; observations for 296 pairs of data points.  

XJ is input gas rate in cubic feet per minute, YJ is percentage carbon dioxide (CO2) in outlet gas.  X is the regressor.
}
\usage{data(SeriesJ)}
\format{
List with ts objects XJ and YJ.
}
\details{
Box, Jenkins, and Reinsel (2008) fit an AR(2) to YJ, with transfer function specifications r = 2, s = 2, and b = 3, regressing on XJ. 
Our package agrees with their results.

}
\source{
Box, Jenkins and Reinsel(2008). 
Time Series Analysis: Forecasting and Control.
}
\references{
Box, G. E. P., Jenkins, G. M., and Reinsel, G. C. (2008) 
Time Series Analysis:  Forecasting and Control.  4th Edition.
John Wiley and Sons, Inc., New Jersey.

Veenstra, J. and McLeod, A. I. (Working Paper).
The arfima R package: Exact Methods for Hyperbolic Decay Time Series

} 
\examples{
data(SeriesJ)
attach(SeriesJ)

fitTF1 <- arfima(YJ, order= c(2, 0, 0), xreg = XJ, reglist = list(regpar = c(2, 2, 3)), lmodel = "n")
fitTF1  ## agrees fairly closely with Box et. al.

fitTF2 <- arfima(YJ, order= c(2, 0, 0), xreg = XJ, reglist = list(regpar = c(1, 2, 3)), lmodel = "n", dmean = FALSE) #dmean = FALSE to turn off the message
fitTF2  ##same as above

tacfplot(list(fitTF1, fitTF2))

detach(SeriesJ)
}
\keyword{datasets}
