\name{fmri.data-class}
\Rdversion{1.1}
\docType{class}
\alias{fmri.data-class}
\alias{.fmri.data.aux_file,fmri.data-method}
\alias{.fmri.data.aux_file<-,fmri.data-method}
\alias{.fmri.data.bitpix,fmri.data-method}
\alias{.fmri.data.bitpix<-,fmri.data-method}
\alias{.fmri.data.cal_max,fmri.data-method}
\alias{.fmri.data.cal_max<-,fmri.data-method}
\alias{.fmri.data.cal_min,fmri.data-method}
\alias{.fmri.data.cal_min<-,fmri.data-method}
\alias{.fmri.data.data_type,fmri.data-method}
\alias{.fmri.data.data_type<-,fmri.data-method}
\alias{.fmri.data.data.signed,fmri.data-method}
\alias{.fmri.data.data.signed<-,fmri.data-method}
\alias{.fmri.data.data.type,fmri.data-method}
\alias{.fmri.data.data.type<-,fmri.data-method}
\alias{.fmri.data.datatype,fmri.data-method}
\alias{.fmri.data.datatype<-,fmri.data-method}
\alias{.fmri.data.datavec,fmri.data-method}
\alias{.fmri.data.datavec<-,fmri.data-method}
\alias{.fmri.data.db_name,fmri.data-method}
\alias{.fmri.data.db_name<-,fmri.data-method}
\alias{.fmri.data.descrip,fmri.data-method}
\alias{.fmri.data.descrip<-,fmri.data-method}
\alias{.fmri.data.dim_info,fmri.data-method}
\alias{.fmri.data.dim_info<-,fmri.data-method}
\alias{.fmri.data.dims,fmri.data-method}
\alias{.fmri.data.dims<-,fmri.data-method}
\alias{.fmri.data.endian,fmri.data-method}
\alias{.fmri.data.endian<-,fmri.data-method}
\alias{.fmri.data.extension,fmri.data-method}
\alias{.fmri.data.extension<-,fmri.data-method}
\alias{.fmri.data.extents,fmri.data-method}
\alias{.fmri.data.extents<-,fmri.data-method}
\alias{.fmri.data.filename,fmri.data-method}
\alias{.fmri.data.filename<-,fmri.data-method}
\alias{.fmri.data.filetype,fmri.data-method}
\alias{.fmri.data.filetype<-,fmri.data-method}
\alias{.fmri.data.fullpath,fmri.data-method}
\alias{.fmri.data.fullpath<-,fmri.data-method}
\alias{.fmri.data.glmax,fmri.data-method}
\alias{.fmri.data.glmax<-,fmri.data-method}
\alias{.fmri.data.glmin,fmri.data-method}
\alias{.fmri.data.glmin<-,fmri.data-method}
\alias{.fmri.data.gzipped,fmri.data-method}
\alias{.fmri.data.gzipped<-,fmri.data-method}
\alias{.fmri.data.intent_code,fmri.data-method}
\alias{.fmri.data.intent_code<-,fmri.data-method}
\alias{.fmri.data.intent_name,fmri.data-method}
\alias{.fmri.data.intent_name<-,fmri.data-method}
\alias{.fmri.data.intent_p1,fmri.data-method}
\alias{.fmri.data.intent_p1<-,fmri.data-method}
\alias{.fmri.data.intent_p2,fmri.data-method}
\alias{.fmri.data.intent_p2<-,fmri.data-method}
\alias{.fmri.data.intent_p3,fmri.data-method}
\alias{.fmri.data.intent_p3<-,fmri.data-method}
\alias{.fmri.data.magic,fmri.data-method}
\alias{.fmri.data.magic<-,fmri.data-method}
\alias{.fmri.data.pixdim,fmri.data-method}
\alias{.fmri.data.pixdim<-,fmri.data-method}
\alias{.fmri.data.qform_code,fmri.data-method}
\alias{.fmri.data.qform_code<-,fmri.data-method}
\alias{.fmri.data.qoffset_x,fmri.data-method}
\alias{.fmri.data.qoffset_x<-,fmri.data-method}
\alias{.fmri.data.qoffset_y,fmri.data-method}
\alias{.fmri.data.qoffset_y<-,fmri.data-method}
\alias{.fmri.data.qoffset_z,fmri.data-method}
\alias{.fmri.data.qoffset_z<-,fmri.data-method}
\alias{.fmri.data.quatern_b,fmri.data-method}
\alias{.fmri.data.quatern_b<-,fmri.data-method}
\alias{.fmri.data.quatern_c,fmri.data-method}
\alias{.fmri.data.quatern_c<-,fmri.data-method}
\alias{.fmri.data.quatern_d,fmri.data-method}
\alias{.fmri.data.quatern_d<-,fmri.data-method}
\alias{.fmri.data.regular,fmri.data-method}
\alias{.fmri.data.regular<-,fmri.data-method}
\alias{.fmri.data.scl_inter,fmri.data-method}
\alias{.fmri.data.scl_inter<-,fmri.data-method}
\alias{.fmri.data.scl_slope,fmri.data-method}
\alias{.fmri.data.scl_slope<-,fmri.data-method}
\alias{.fmri.data.session_error,fmri.data-method}
\alias{.fmri.data.session_error<-,fmri.data-method}
\alias{.fmri.data.sform_code,fmri.data-method}
\alias{.fmri.data.sform_code<-,fmri.data-method}
\alias{.fmri.data.sizeof_hdr,fmri.data-method}
\alias{.fmri.data.sizeof_hdr<-,fmri.data-method}
\alias{.fmri.data.slice_code,fmri.data-method}
\alias{.fmri.data.slice_code<-,fmri.data-method}
\alias{.fmri.data.slice_duration,fmri.data-method}
\alias{.fmri.data.slice_duration<-,fmri.data-method}
\alias{.fmri.data.slice_end,fmri.data-method}
\alias{.fmri.data.slice_end<-,fmri.data-method}
\alias{.fmri.data.slice_start,fmri.data-method}
\alias{.fmri.data.slice_start<-,fmri.data-method}
\alias{.fmri.data.srow_x,fmri.data-method}
\alias{.fmri.data.srow_x<-,fmri.data-method}
\alias{.fmri.data.srow_y,fmri.data-method}
\alias{.fmri.data.srow_y<-,fmri.data-method}
\alias{.fmri.data.srow_z,fmri.data-method}
\alias{.fmri.data.srow_z<-,fmri.data-method}
\alias{.fmri.data.toffset,fmri.data-method}
\alias{.fmri.data.toffset<-,fmri.data-method}
\alias{.fmri.data.version,fmri.data-method}
\alias{.fmri.data.version<-,fmri.data-method}
\alias{.fmri.data.vox_offset,fmri.data-method}
\alias{.fmri.data.vox_offset<-,fmri.data-method}
\alias{.fmri.data.xyzt_units,fmri.data-method}
\alias{.fmri.data.xyzt_units<-,fmri.data-method}
\alias{plot,fmri.data,missing-method}
\alias{show,fmri.data-method}
\alias{summary,fmri.data-method}

\title{arf3DS4 "fmri.data" class }
\description{The arf3DS4 "fmri.data" class contains the header information and data of an ANALYZE/NIFTI functional volume. It is essentially a \code{\linkS4class{nifti.header}} object with an added "datavec" slot.}
\section{Objects}{
Objects can be created by calls of the form \code{new("fmri.data", ...)}.
}
\section{Slots}{
	 \describe{
    \item{\code{datavec}:}{Vector containing the actual fMRI data. }
    \item{\code{sizeof_hdr}:}{<nifti> Size of the header file.}
    \item{\code{data_type}:}{<nifti> Type of data (representation). }
    \item{\code{db_name}:}{<nifti> db_name.}
    \item{\code{extents}:}{<nifti> extents}
    \item{\code{session_error}:}{<nifti> session error. }
    \item{\code{regular}:}{<nifti> regular }
    \item{\code{dim_info}:}{<nifti> MRI slice ordering. }
    \item{\code{dims}:}{<nifti> Data array dimensions. }
    \item{\code{intent_p1}:}{<nifti> 1st intent parameter.}
    \item{\code{intent_p2}:}{<nifti> 2nd intent parameter.}
    \item{\code{intent_p3}:}{<nifti> 3rd intent parameter.}
    \item{\code{intent_code}:}{<nifti> Intent code.}
    \item{\code{datatype}:}{<nifti> Data type.}
    \item{\code{bitpix}:}{<nifti> Number of bits per voxel.}
    \item{\code{slice_start}:}{<nifti> First slice index. }
    \item{\code{pixdim}:}{<nifti> Grid spacing (single voxel dimensions).}
    \item{\code{vox_offset}:}{<nifti> Offset in the .nii file. }
    \item{\code{scl_slope}:}{<nifti> Data scaling, slope. }
    \item{\code{scl_inter}:}{<nifti> Data scaling, offset. }
    \item{\code{slice_end}:}{<nifti> Last slice index. }
    \item{\code{slice_code}:}{<nifti> Slice timing order. }
    \item{\code{xyzt_units}:}{<nifti> Units of single voxel dimensions. }
    \item{\code{cal_max}:}{<nifti> Maximum display intensity. }
    \item{\code{cal_min}:}{<nifti> Minimum display intensity. }
    \item{\code{slice_duration}:}{<nifti> Time for one slice (TR).}
    \item{\code{toffset}:}{<nifti> Shift in time. }
    \item{\code{glmax}:}{<nifti> glmax. }
    \item{\code{glmin}:}{<nifti> glmin. }
    \item{\code{descrip}:}{<nifti> Description of file.}
    \item{\code{aux_file}:}{<nifti> An auxilliary filename. }
    \item{\code{qform_code}:}{<nifti> q_form code. }
    \item{\code{sform_code}:}{<nifti> s_form code.}
    \item{\code{quatern_b}:}{<nifti> quaternion b parameter. }
    \item{\code{quatern_c}:}{<nifti> quaternion c parameter. }
    \item{\code{quatern_d}:}{<nifti> quaternion d parameter. }
    \item{\code{qoffset_x}:}{<nifti> q offset x parameter. }
    \item{\code{qoffset_y}:}{<nifti> q offset y parameter. }
    \item{\code{qoffset_z}:}{<nifti> q offset z parameter.}
    \item{\code{srow_x}:}{<nifti> 1st row affine transformation. }
    \item{\code{srow_y}:}{<nifti> 2nd row affine transformation.  }
    \item{\code{srow_z}:}{<nifti> 3rd row affine transformation. }
    \item{\code{intent_name}:}{<nifti> Meaning of data. }
    \item{\code{magic}:}{<nifti> nifti magicstring.  }
    \item{\code{data.type}:}{<arf3DS4> Data type. }
    \item{\code{data.signed}:}{<arf3DS4> Signed data. }
    \item{\code{fullpath}:}{<arf3DS4> Full path of datafile. }
    \item{\code{filename}:}{<arf3DS4> Filename. }
    \item{\code{filetype}:}{<arf3DS4> Type of file. }
    \item{\code{extension}:}{<arf3DS4> File extension. }
    \item{\code{gzipped}:}{<arf3DS4> Is the file gzipped? }
    \item{\code{endian}:}{<arf3DS4> Endianness of file. }
    \item{\code{version}:}{Object of class "version" (see \code{\linkS4class{version}})}
  }
}
\section{Extends}{
Class \code{"\linkS4class{nifti.header}"}, directly.
Class \code{"\linkS4class{nifti.fileinfo}"}, by class "nifti.header".
}
\section{Methods}{
 Standard arf3DS4 accessor and replacement functions can be used to access and replace slots. 
  \describe{
 	\item{access}{\code{.classname.slotname(object)}}
    \item{replace}{\code{.classname.slotname(object)<-}}
    \item{plot}{\code{signature(x = "fmri.data", y = "missing")}: ... }
    \item{show}{\code{signature(object = "fmri.data")}: ... }
    \item{summary}{\code{signature(object = "fmri.data")}: ... }
	 }
 In this case classname is "fmri.data" and slotname is for example "dims". So to access the "dims" slot of an r-object "myfmridata"  (of class "fmri.data") type \code{.fmri.data.dims(myfmridata)}.
}
\references{ See the Nifti homepage (\url{http://nifti.nimh.nih.gov/}) for more information on the nifti filetype.}
\author{ Wouter D. Weeda - w.d.weeda@gmail.com }
\seealso{
	\code{\linkS4class{nifti.header}},\code{\linkS4class{nifti.fileinfo}}
}
\examples{
showClass("fmri.data")
}
\keyword{classes}
