% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lik.R
\name{lik}
\alias{lik}
\title{Likelihood Estimation}
\usage{
lik(arf, params, x, oob = FALSE, log = TRUE, batch = NULL, parallel = TRUE)
}
\arguments{
\item{arf}{Pre-trained \code{\link{adversarial_rf}}. Alternatively, any
object of class \code{ranger}.}

\item{params}{Parameters learned via \code{\link{forde}}.}

\item{x}{Input data. Densities will be computed for each sample.}

\item{oob}{Only use out-of-bag leaves for likelihood estimation? If
\code{TRUE}, \code{x} must be the same dataset used to train \code{arf}.}

\item{log}{Return likelihoods on log scale? Recommended to prevent underflow.}

\item{batch}{Batch size. The default is to compute densities for all of
\code{x} in one round, which is always the fastest option if memory allows.
However, with large samples or many trees, it can be more memory efficient
to split the data into batches. This has no impact on results.}

\item{parallel}{Compute in parallel? Must register backend beforehand, e.g.
via \code{doParallel}.}
}
\value{
A vector of likelihoods, optionally on the log scale.
}
\description{
Compute the density of input data.
}
\details{
This function computes the density of input data according to a FORDE model
using a pre-trained ARF. Each sample's likelihood is a weighted average of
its likelihood in all leaves whose split criteria it satisfies. Intra-leaf
densities are fully factorized, since ARFs satisfy the local independence
criterion by construction. See Watson et al. (2022).
}
\examples{
# Estimate average log-likelihood
arf <- adversarial_rf(iris)
psi <- forde(arf, iris)
ll <- lik(arf, psi, iris, log = TRUE)
mean(ll)


}
\references{
Watson, D., Blesch, K., Kapar, J., & Wright, M. (2022). Adversarial random
forests for density estimation and generative modeling. \emph{arXiv} preprint,
2205.09435.
}
\seealso{
\code{\link{adversarial_rf}}, \code{\link{forge}}
}
