% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchUnits.R
\name{matchUnits}
\alias{matchUnits}
\title{Determine the administrative hierarchy ID}
\usage{
matchUnits(input = NULL, source = NULL, verbose = FALSE)
}
\arguments{
\item{input}{[\code{data.frame(1)}]\cr table in which to match administrative
units.}

\item{source}{[\code{integerish(1)}]\cr the geometry ID (\code{geoID}) from
which the terms have been taken.}

\item{verbose}{[\code{logical(1)}]\cr be verbose about what is happening
(default \code{FALSE}).}
}
\value{
The table provided in \code{input}, where the given columns are
  replaced by the column \code{ahID}, which contains the administrative
  hierarchy ID.
}
\description{
This function matches territorial units with a list of known units to derive
the administrative hierarchy ID.
}
\details{
\code{names(input)} must contain at least the \code{al1 = ...} to
  match at least a certain nation. Further administrative levels are denoted
  by column names \code{al2}, \code{al3}, ...
}
