% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryRepo.R
\name{summaryLocalRepo}
\alias{summaryLocalRepo}
\alias{summaryRemoteRepo}
\title{View the Summary of the Repository}
\usage{
summaryLocalRepo(repoDir = aoptions("repoDir"))

summaryRemoteRepo(repo = aoptions("repo"), user = aoptions("user"),
  branch = "master", subdir = aoptions("subdir"),
  repoType = aoptions("repoType"))
}
\arguments{
\item{repoDir}{A character denoting an existing directory of the Repository for which a summary will be returned.}

\item{repo}{While working with the Remote repository. A character containing a name of the Remote repository on which the Repository is stored.
By default set to \code{NULL} - see \code{Note}.}

\item{user}{While working with the Remote repository. A character containing a name of the Remote user on whose account the \code{repo} is created.
By default set to \code{NULL} - see \code{Note}.}

\item{branch}{While working with the Remote repository. A character containing a name of 
the Remote Repository's branch on which the Repository is stored. Default \code{branch} is \code{master}.}

\item{subdir}{While working with the Remote repository. A character containing a name of a directory on the Remote repository 
on which the Repository is stored. If the Repository is stored in the main folder of the Remote repository, this should be set 
to \code{subdir = "/"} as default.}

\item{repoType}{A character containing a type of the remote repository. Currently it can be 'github' or 'bitbucket'.}
}
\value{
An object of class \code{repository} which can be printed: \code{print(object)}.
}
\description{
\code{summaryRepo} summarizes the current state of the \link{Repository}.
}
\details{
\code{summaryRepo} summarizes the current state of a \link{Repository}. Recommended to use
\code{print( summaryRepo ) )}. See examples.
}
\note{
If the same artifact was archived many times then it is counted as one artifact or database in \code{print(summaryRepo)}.

Bug reports and feature requests can be sent to \href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
  
If \code{repo} and \code{user} are set to \code{NULL} (as default) in the Remote mode then global parameters
set in \link{setRemoteRepo} function are used.
}
\examples{
\dontrun{

showLocalRepo(repoDir = system.file("graphGallery", package = "archivist"))
#
# Remote version
#
 
x <- summaryRemoteRepo( user="pbiecek", repo="archivist")
print( x )

# many archivist-like Repositories on one Remote repository
  
summaryRemoteRepo(user="MarcinKosinski", repo="Museum", 
branch="master", subdir="ex2" )

}
}
\author{
Marcin Kosinski , \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}}, \code{\link{zipLocalRepo}}
}

