% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/archive.R
\name{archive}
\alias{archive}
\title{Archive Artifact to Local and Github Repository}
\usage{
archive(artifact, commitMessage = aoptions("commitMessage"),
  repo = aoptions("repo"), user.name = aoptions("user.name"),
  user.password = aoptions("user.password"),
  archiveData = aoptions("archiveData"),
  archiveTags = aoptions("archiveTags"),
  archiveMiniature = aoptions("archiveMiniature"),
  force = aoptions("force"), rememberName = aoptions("rememberName"), ...,
  userTags = c(), silent = aoptions("silent"), ascii = aoptions("ascii"))
}
\arguments{
\item{artifact}{An artifact to be archived on Local and Github \link{Repository}.}

\item{commitMessage}{A character denoting a message added to the commit while archiving \code{artifact} on GitHub Repository.
By default, an artifact's \link{md5hash} is added to the commit message when it is specified to \code{NULL}.}

\item{repo}{A character denoting GitHub repository name and synchronized local existing directory in which an artifact will be saved.}

\item{user.name}{A character denoting GitHub user name. Can be set globally with \code{aoptions("user.name", user.name)}.
See \link{archivist-github-integration}.}

\item{user.password}{A character denoting GitHub user password. Can be set globally with \code{aoptions("user.password", user.password)}.
See \link{archivist-github-integration}.}

\item{archiveData}{A logical value denoting whether to archive the data from the \code{artifact}.}

\item{archiveTags}{A logical value denoting whether to archive Tags from the \code{artifact}.}

\item{archiveMiniature}{A logical value denoting whether to archive a miniature of the \code{artifact}.}

\item{force}{A logical value denoting whether to archive \code{artifact} if it was already archived in
a Repository.}

\item{rememberName}{A logical value. Should not be changed by a user. It is a technical parameter.}

\item{...}{Graphical parameters denoting width and height of a miniature. See details.
Further arguments passed to \link{head}. See Details section in \link{saveToRepo} about \code{firtsRows} parameter}

\item{userTags}{A character vector with Tags. These Tags will be added to the repository along with the artifact.}

\item{silent}{If TRUE produces no warnings.}

\item{ascii}{A logical value. An \code{ascii} argument is passed to \link{save} function.}
}
\description{
\code{archive} stores artifacts in the local \link{Repository} and automatically pushes archived
artifacts to the Github \code{Repository} with which the local \code{Repository} is synchronized
(via \link{createEmptyGithubRepo} or \link{cloneGithubRepo}). Function stores artifacts on the same
way as \link{saveToRepo} function. More archivist functionalities that integrate archivist and GitHub API
 can be found here \link{archivist-github-integration} (\link{agithub}).
}
\examples{
\dontrun{

# empty Github Repository creation

library(httr)
myapp <- oauth_app("github",
                   key = '1fab1e77d27079c0717d',
                   secret = 'c1284ed206b4a7f5f0bca508a6df5919e7fbf799')
github_token <- oauth2.0_token(oauth_endpoints("github"),
                               myapp,
                               scope = "public_repo")
# setting options
aoptions("github_token", github_token)
aoptions("user.name", 'MarcinKosinski')
aoptions("user.password", 'sobieskiego77')

createEmptyGithubRepo("archive-test4")
setGithubRepo(aoptions("user.name"), "archive-test4")
## artifact's archiving
przyklad <- 1:100

# archiving
archive(przyklad) -> md5hash_path

## proof that artifact is really archived
showGithubRepo() # uses options from setGithubRepo
# let's remove przyklad
rm(przyklad)
# and load it back from md5hash_path
aread(md5hash_path)


# clone example
unlink("archive-test", recursive = TRUE)
cloneGithubRepo('https://github.com/MarcinKosinski/archive-test')
setGithubRepo(aoptions("user.name"), "archive-test")
data(iris)
archive(iris)
showGithubRepo()


}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{agithub}},
  \code{\link{archivist-github-integration}};
  \code{\link{ahistory}}; \code{\link{aoptions}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{cloneGithubRepo}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyGithubRepo}},
  \code{\link{createEmptyLocalRepo}},
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{splitTagsGithub}},
  \code{\link{splitTagsLocal}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

