% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-reverse-geocode.R
\name{reverse_geocode}
\alias{reverse_geocode}
\title{Reverse Geocode Locations}
\usage{
reverse_geocode(
  locations,
  crs = sf::st_crs(locations),
  ...,
  lang_code = NULL,
  feature_type = NULL,
  location_type = c("rooftop", "street"),
  preferred_label_values = c("postalCity", "localCity"),
  for_storage = FALSE,
  geocoder = default_geocoder(),
  token = arc_token(),
  .progress = TRUE
)
}
\arguments{
\item{locations}{an \code{sfc_POINT} object of the locations to be reverse geocoded.}

\item{crs}{the CRS of the returned geometries. Passed to \code{sf::st_crs()}.
Ignored if \code{locations} is not an \code{sfc_POINT} object.}

\item{...}{unused.}

\item{lang_code}{default \code{NULL}. An ISO 3166 country code.
See \code{\link[=iso_3166_codes]{iso_3166_codes()}} for valid ISO codes. Optional.}

\item{feature_type}{limits the possible match types returned. Must be one of
\code{"StreetInt"}, \code{"DistanceMarker"}, \code{"StreetAddress"}, \code{"StreetName"},
\code{"POI"}, \code{"Subaddress"}, \code{"PointAddress"}, \code{"Postal"}, or \code{"Locality"}. Optional.}

\item{location_type}{default \code{"rooftop"}. Must be one of \code{"rooftop"} or \code{"street"}.
Optional.}

\item{preferred_label_values}{default NULL. Must be one of \code{"postalCity"}
or \code{"localCity"}. Optional.}

\item{for_storage}{default \code{FALSE}. Whether or not the results will be saved
for long term storage.}

\item{geocoder}{default \code{\link[=default_geocoder]{default_geocoder()}}.}

\item{token}{an object of class \code{httr2_token} as generated by \code{\link[arcgisutils:auth_code]{auth_code()}}
or related function}

\item{.progress}{default \code{TRUE}. Whether a progress bar should be provided.}
}
\value{
An sf object.
}
\description{
Determines the address for a given point.
}
\details{
This function utilizes the
\href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-reverse-geocode.htm}{\verb{/reverseGeocode}} endpoint of a geocoding service. By default, it uses
the public ArcGIS World Geocoder.
\itemize{
\item Intersection matches are only returned when \code{feature_types = "StreetInt"}. See \href{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-reverse-geocode.htm#ESRI_SECTION3_1FE6B6D350714E45B2707845ADA22E1E}{REST documentation for more}.
}
\subsection{Location Type}{
\itemize{
\item Specifies whether the output geometry shuold be the rooftop point or the
street entrance location.
\item The \code{location_type} parameter changes the geometry's placement but does not
change the attribute values of \code{X}, \code{Y}, or \code{DisplayX}, and \code{DisplayY}.
}
}

\subsection{Storage}{

\strong{Very Important}

The argument \code{for_storage} is used to determine if the request allows you to
persist the results of the query. It is important to note that there are
contractual obligations to appropriately set this argument. \strong{You cannot save
or persist results} when \code{for_storage = FALSE} (the default).
}

\subsection{Execution}{

The \verb{/reverseGeocode} endpoint can only handle one address at a time. To
make the operation as performant as possible, requests are sent in parallel
using \code{\link[httr2:req_perform_parallel]{httr2::req_perform_parallel()}}. The JSON responses are then processed
using Rust and returned as an sf object.
}
}
\examples{
# Find addresses from locations
reverse_geocode(c(-117.172, 34.052))
}
