% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateSoilColor.R
\name{estimateSoilColor}
\alias{estimateSoilColor}
\title{Estimate dry soil colors from moist soil colors and vice versa.}
\usage{
estimateSoilColor(hue, value, chroma, sourceMoistureState = c("dry", "moist"))
}
\arguments{
\item{hue}{vector of Munsell hue ('10YR', '2.5Y', etc.)}

\item{value}{vector of Munsell value (2,2.5 2.5, 3, 5, 6, etc.)}

\item{chroma}{vector of Munsell chroma (2, 3, 4, etc.)}

\item{sourceMoistureState}{character, source colors are either 'dry' or 'moist'}
}
\value{
\code{data.frame} of estimated colors in Munsell notation. The \code{sigma} column contains CIE2000 color contrast metric values describing the perceptual distance between estimated color in CIELAB coordinates and closest Munsell chip.
}
\description{
Soil color is typically described at dry and moist conditions. This function attempts to estimate soil color at dry or moist condition when one is missing. Estimation proceeds as:
\itemize{
\item convert Munsell notation to CIELAB color coordinates via \code{munsell2rgb()}
\item apply scaling, rotation, and translation parameters in CIELAB color space
\item convert CIELAB to sRGB coordinates
\item locate closest Munsell chip to sRGB coordinates via \code{col2munsell()}
}

Estimation of dry from moist soil color state is not guaranteed to be symmetric with estimation of moist from dry.
}
\details{
Scaling, rotation, and translation parameters for shifting between dry <--> moist CIELAB coordinates was determined using \code{vegan::procrustes()}, from those official series descriptions (OSD) where moist and dry soil colors were available.

Estimates for colors having a (dry or moist) Munsell value of 10 are not likely correct.

This is still a work in progress.
}
\examples{

# keep examples from using more than 2 cores
data.table::setDTthreads(Sys.getenv("OMP_THREAD_LIMIT", unset = 2))

estimateSoilColor(hue = '10YR', value = 3, chroma = 3, sourceMoistureState = 'moist')

# note that estimation is not symmetric
estimateSoilColor(hue = '10YR', value = 5, chroma = 3, sourceMoistureState = 'dry')

}
\author{
D.E. Beaudette
}
