% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-methods.R
\name{subsetHz,SoilProfileCollection-method}
\alias{subsetHz,SoilProfileCollection-method}
\alias{subsetHz}
\title{Subset the horizons in a SoilProfileCollection using logical criteria}
\usage{
\S4method{subsetHz}{SoilProfileCollection}(x, ...)
}
\arguments{
\item{x}{a SoilProfileCollection}

\item{...}{Comma-separated set of R expressions that evaluate as \code{TRUE} or \code{FALSE} in context of horizon data frame. Length for individual expressions matches number of horizons, in \code{x}.}
}
\value{
a SoilProfileCollection with a subset of horizons, possibly with some sites removed
}
\description{
Subset the horizons in a SoilProfileCollection using logical criteria
}
\examples{

data(sp3)

depths(sp3) <- id ~ top + bottom

# show just horizons with 10YR hues
plot(subsetHz(sp3, hue == '10YR'))

}
