% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/runAPSIM.R
\name{example_apsim}
\alias{example_apsim}
\title{Access Example APSIM Simulations}
\usage{
example_apsim(path, wd = getwd(), files = NULL, ...)
}
\arguments{
\item{path}{path to the APSIM installation}

\item{wd}{working directory containing the .apsim files to be copied; defaults to the current working directory}

\item{files}{files to extract from the "Examples" folder}

\item{...}{additional arguments passed to \code{\link[base:file.copy]{file.copy}}}
}
\value{
logical; if \code{TRUE} the corresponding file was successfully copied, \code{FALSE} otherwise
}
\description{
Standard APSIM simulations are provided by the default APSIM installation.
\code{apsim_example} moves those example files into the working directory \code{wd} so you can run them
or edit them using \code{\link{apsim}} and \code{\link{edit_apsim}}, respectively.  Generally the
example simulations must be moved because the output file is written to the directory containing
the .apsim file and the ability to write in the "Program Files" can be limited in some cases.
}
\examples{
\dontrun{
apsimPath <-"C:/Program Files (x86)/Apsim75-r3008/"
apsimWd <- "~/APSIM"
toRun <- "Canopy.apsim"
example_apsim(path = apsimPath, wd = apsimWd, files = toRun) #TRUE

toRun <- c("Canopy.apsim", "Continuous Wheat.apsim")
example_apsim(path = apsimPath, wd = apsimWd, files = toRun) #TRUE TRUE

apsimExe <-"C:/Program Files (x86)/Apsim75-r3008/Model/Apsim.exe"
results <- apsim(exe = apsimExe, wd = apsimWd, files = toRun)
plot(results[[1]])
}
}

