% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transport_plan.R
\name{general_1d_transport}
\alias{general_1d_transport}
\title{One-dimensional optimal transport for measures with more general mass}
\usage{
general_1d_transport(
  X,
  Y,
  a = NULL,
  b = NULL,
  method = c("hilbert", "univariate")
)
}
\arguments{
\item{X}{Data for sample one. Should be a vector if method is "univariate" or a matrix if method is "hilbert"}

\item{Y}{Data for sample two Should be a vector if method is "univariate" or a matrix if method is "hilbert"}

\item{a}{Empirical measure for sample one.}

\item{b}{Empirical measure for sample two.}

\item{method}{One of "hilbert" or "univariate"}
}
\value{
An optimal transportation plan as a list with slots "from", "to", and "mass"
}
\description{
One-dimensional optimal transport for measures with more general mass
}
\examples{
set.seed(23423)
n <- 100
d <- 10
x <- matrix(stats::rnorm((n + 11)*d), n + 11 , d)
y <- matrix(stats::rnorm(n*d), n, d)

trans <- general_1d_transport(t(x), t(y))
}
\keyword{internal}
