% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{itunes_artists}
\alias{itunes_artists}
\title{iTunes Artists}
\format{
A data frame with 2 columns and 10 rows
\describe{
\item{artist}{Artist name}
\item{artist_id}{Apple ID of the artist}
}
}
\source{
<https://music.apple.com>
}
\usage{
itunes_artists
}
\description{
A small dataset containing current artists available on iTunes with
a corresponding ID that can be used in {appler} functions.

To see more information about the artist online, you can add the following
URL in your browser: music.apple.com/artist/<id> where <id> is the `artist_id`
column
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get information about Microsoft Teams
lizzo <- itunes_artists[itunes_artists$artist == "Lizzo", ]
lizzo_id <- lizzo$artist_id
lizzo_name <- lizzo$artist

# Search for artist by name, can find the ID from this query
search_apple(term = lizzo_name, country = "ca", lang = "en")

# Get information about the artist
lookup_apple(id = lizzo_id, country = "ca", sort = "recent")
\dontshow{\}) # examplesIf}
}
\keyword{datasets}
