% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulas.R
\name{aphylo-model}
\alias{aphylo-model}
\alias{aphylo-formula}
\alias{eta}
\alias{psi}
\alias{Pi}
\alias{mu_d}
\alias{mu_s}
\alias{aphylo_formula}
\title{Formulas in \code{aphylo}}
\usage{
eta(..., env)

psi(..., env)

Pi(..., env)

mu_d(..., env)

mu_s(..., env)

aphylo_formula(fm, params, priors, env = parent.frame())
}
\arguments{
\item{...}{Either 0, 1 or both. Depending on the parameter, the index of the
model parameter that will be set as fixed.}

\item{env}{Environment (not to be called by the user).}

\item{fm}{A formula. Model of the type \verb{<aphylo-object> ~ <parameters>} (see
examples).}

\item{params}{Numeric vector with model parameters.}

\item{priors}{(optional) A function. Prior for the model.}
}
\value{
A list with the following elements:
\itemize{
\item \code{fun} A function. The log-likelihood function.
\item \code{fixed} Logical vector.
}
}
\description{
This function the the workhorse behind the likelihood function. It creates
arbitrary models by modifying the call to \code{\link[=LogLike]{LogLike()}} function according to
what the user specifies as model.
}
\examples{
set.seed(12)
x <- raphylo(10)

# Baseline model
aphylo_formula(x ~ mu_d)

# Mislabeling probabilities
aphylo_formula(x ~ mu_d + psi)

# Different probabilities for speciation and duplication node
# (only works if you have both types)
aphylo_formula(x ~ mu_d + mu_s + psi)

# Mislabeling probabilities and etas(fixed)
aphylo_formula(x ~ mu_d + psi + eta(0, 1))

# Mislabeling probabilities and Pi 
aphylo_formula(x ~ mu_d + psi + Pi)

}
