% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_score.R
\name{plot.aphylo_prediction_score}
\alias{plot.aphylo_prediction_score}
\alias{plot-prediction}
\title{Visualize predictions}
\usage{
\method{plot}{aphylo_prediction_score}(
  x,
  y = NULL,
  main = "Prediction Accuracy: Observed versus predicted values",
  main.colorkey = "Probability of Functional Annotation",
  which.fun = seq_len(ncol(x$expected)),
  include.labels = NULL,
  labels.col = "black",
  leafs_only = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{aphylo_prediction_score}.}

\item{y}{Ignored.}

\item{main}{Passed to \code{title}.}

\item{main.colorkey}{Character scalar. Title of the colorkey (optional).}

\item{which.fun}{Integer vector. Which function to plot.}

\item{include.labels}{Logical scalar. When \code{TRUE}, draws nice labels
at each slice which by default are specified as the rownames of \code{x$expected}.
This is mostly useful when the number of predictions is small.}

\item{labels.col}{Character scalar. Color of the labels.}

\item{leafs_only}{Logical. When \code{TRUE} (default) only plots the leaf nodes.}

\item{...}{Ignored}
}
\value{
NULL (invisible) Generates a plot of the predictions.
}
\description{
Visualize predictions
}
\details{
If \code{include.labels = NULL} and \code{ncol(x$expected) > 40},
then \code{include.labels=FALSE} by default.
}
\examples{
set.seed(8783)
atree  <- raphylo(29)
ans    <- aphylo_mle(atree ~ mu_d + mu_s + Pi)
pred_s <- prediction_score(ans)

pred_s
plot(pred_s)
}
