% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_colors}
\alias{ax_colors}
\title{Colors}
\usage{
ax_colors(ax, ...)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{...}{Colors for the chart's series. When all colors are used, it starts from the beginning.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Colors
}
\note{
See \url{https://apexcharts.com/docs/options/colors/}
}
\examples{
data("diamonds", package = "ggplot2")

# Change default color(s)
apex(
  data = diamonds,
  mapping = aes(x = cut)
) \%>\%
  ax_colors("#F7D358")


library(scales)
apex(
  data = diamonds,
  mapping = aes(x = cut, fill = color)
) \%>\%
  ax_colors(brewer_pal(palette = "Set2")(7))
}
