% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{sedona_read_shapefile}
\alias{sedona_read_shapefile}
\title{Create a SpatialRDD from a shapefile data source.}
\usage{
sedona_read_shapefile(sc, location, storage_level = "MEMORY_ONLY")
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{location}{Location of the data source.}

\item{storage_level}{Storage level of the RDD (default: MEMORY_ONLY).}
}
\value{
A SpatialRDD.
}
\description{
Create a generic SpatialRDD from a shapefile data source.
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- sedona_read_shapefile(sc, location = input_location)
}

}
\seealso{
Other Sedona data inferface functions: 
\code{\link{sedona_read_dsv_to_typed_rdd}()},
\code{\link{sedona_read_geojson_to_typed_rdd}()},
\code{\link{sedona_read_geojson}()},
\code{\link{sedona_read_shapefile_to_typed_rdd}()},
\code{\link{sedona_read_wkb}()},
\code{\link{sedona_read_wkt}()},
\code{\link{sedona_save_spatial_rdd}()},
\code{\link{sedona_write_geojson}()},
\code{\link{sedona_write_wkb}()},
\code{\link{sedona_write_wkt}()}
}
\concept{Sedona data inferface functions}
