% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_join_op.R
\name{spatial_join_op}
\alias{spatial_join_op}
\title{Spatial join operator}
\arguments{
\item{spatial_rdd}{Spatial RDD containing geometries to be queried.}

\item{query_window_rdd}{Spatial RDD containing the query window(s).}

\item{join_type}{Type of the join query (must be either "contain" or
"intersect").
If `join_type` is "contain", then a geometry from `spatial_rdd` will match
a geometry from the `query_window_rdd` if and only if the former is fully
contained in the latter.
If `join_type` is "intersect", then a geometry from `spatial_rdd` will
match a geometry from the `query_window_rdd` if and only if the former
intersects the latter.}

\item{partitioner}{Spatial partitioning to apply to both `spatial_rdd` and
`query_window_rdd` to facilitate the join query. Can be either a grid type
(currently "quadtree" and "kdbtree" are supported) or a custom spatial
partitioner object. If `partitioner` is NULL, then assume the same spatial
partitioner has been applied to both `spatial_rdd` and `query_window_rdd`
already and skip the partitioning step.}

\item{index_type}{Controls how `spatial_rdd` and `query_window_rdd` will be
indexed (unless they are indexed already). If "NONE", then no index will be
constructed and matching geometries will be identified in a doubly nested-
loop iterating through all possible pairs of elements from `spatial_rdd`
and `query_window_rdd`, which will be inefficient for large data sets.}
}
\description{
R interface for a Sedona spatial join operator
}
