% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apaDescriptives.R
\name{apa.descriptives}
\alias{apa.descriptives}
\title{Generic method to generate an APA style table with descriptives for MS Word.}
\usage{
apa.descriptives(data = data.frame(), variables = NULL, report = "",
  title = "APA Table", filename = "APA Table.docx", note = NULL,
  position = "lower", merge = FALSE, sig = TRUE, landscape = FALSE,
  save = TRUE)
}
\arguments{
\item{data}{Raw dataset with variables.}

\item{variables}{The variable names for in the table.}

\item{report}{(optional) Specify which descriptive statistics to report. Use a subset from \code{c("M", "SD", "r")}.}

\item{title}{(optional) Name of the table.}

\item{filename}{(optional) Specify the filename (including valid '\code{.docx}' extension).}

\item{note}{(optional) Add a footnote to the bottom of the table.}

\item{position}{(optional) Specify whether the correlations should be displayed in the \code{upper}, or \code{lower} diagonal of the table.}

\item{merge}{(optional) Set (\code{TRUE}) if the mean and standard deviation columns should be merged into one column.}

\item{sig}{(optional) Specify whether the significance should be displayed in a separate column.}

\item{landscape}{(optional) Set (\code{TRUE}) if the table should be generated in landscape mode.}

\item{save}{(optional) Set (\code{FALSE}) if the table should not be saved in a document.}
}
\value{
\code{apa.descriptives} object; a list consisting of
\item{succes}{message in case of an error}
\item{save}{flag which indicates whther the document is saved}
\item{data}{dataset with descriptive statistics}
\item{table}{\code{FlexTable {ReporteRs}} object}
}
\description{
Generic method to generate an APA style table with descriptives for MS Word.
}
\details{
This method can automatically generate tables with descriptive statistics. It's possible to specify which descriptives
should be displayed. The default setting displays all the means, standard deviations, and a correlation matrix. This can
user specified changing the (\code{report}) parameter. For large tables it is also possible to merge the mean and
stadard deviation in one column \dQuote{\emph{M} (\emph{SD})}. This can be done by setting the \code{merge} parameter
to \code{TRUE}. It's also possible to make the columns of the correlation matrix smaller, by removing the significance
asterisks in the table. The significance of the correlation values are highlighted in a footnote (e.g, Correlation
coefficients > |0.23| are significant at \emph{p} < 0.036."). This can be done by setting the \code{sig} parameter to
\code{FALSE}.
}
\examples{

# Use apa.descriptives function
apa.descriptives(
  data = data.frame(
    rnorm(100, mean = 0, sd = 1),
    rnorm(100, mean = 0, sd = 1),
    rnorm(100, mean = 0, sd = 1),
    rnorm(100, mean = 0, sd = 1)
  ),
  variables = c("Column 1", "Column 2", "Column 3", "Column 4")
)
}

